<?php

class EWRporta_ControllerPublic_Portal extends XenForo_ControllerPublic_Abstract
{
	public $perms;

	public function actionIndex()
	{
		$this->canonicalizeRequestUrl(XenForo_Link::buildPublicLink('portal'));

		$options = XenForo_Application::get('options');

		if ($options->EWRporta_stylechoice['force'] && $options->EWRporta_stylechoice['style'])
		{
			$this->setViewStateChange('styleId', $options->EWRporta_stylechoice['style']);
		}

		$viewParams = array(
			'page' => max(1, $this->_input->filterSingle('page', XenForo_Input::UINT)),
		);

		return $this->responseView('EWRporta_ViewPublic_Portal', 'EWRporta_Portal', $viewParams);
	}

	public function actionRevert()
	{
		if ($cookies = XenForo_Helper_Cookie::getCookie('EWRporta'))
		{
			foreach ($cookies AS $key => $cookie)
			{
				XenForo_Helper_Cookie::deleteCookie('EWRporta['.$key.'][order]');
				XenForo_Helper_Cookie::deleteCookie('EWRporta['.$key.'][position]');
			}
		}

		return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, XenForo_Link::buildPublicLink('portal/custom'));
	}

	public function actionCustom()
	{
		if (!$this->perms['custom']) { return $this->responseNoPermission(); }

		if ($this->_request->isPost())
		{
			$order = 0;
			$modules = $this->_input->filterSingle('modules', XenForo_Input::ARRAY_SIMPLE);

			foreach ($modules AS $key => $module)
			{
				XenForo_Helper_Cookie::setCookie('EWRporta['.$key.'][order]', $order++, 31536000);
				XenForo_Helper_Cookie::setCookie('EWRporta['.$key.'][position]', $module, 31536000);
			}

			return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, XenForo_Link::buildPublicLink('portal/custom'));
		}

		$modules = $this->getModelFromCache('EWRporta_Model_Modules')->getModules();
		$blocks = array('top' => array(), 'bottom' => array(), 'left' => array(), 'center' => array(), 'right' => array(), 'disabled' => array());

		foreach ($modules AS $module)
		{
			switch ($module['module_position'])
			{
				case "top":			$blocks['top'][] = $module;			break;
				case "bottom":		$blocks['bottom'][] = $module;		break;
				case "left":		$blocks['left'][] = $module;		break;
				case "center":		$blocks['center'][] = $module;		break;
				case "right":		$blocks['right'][] = $module;		break;
				case "disabled":	$blocks['disabled'][] = $module;	break;
			}
		}

		$viewParams = array(
			'adminModules' => false,
			'blocks' => $blocks,
		);

		return $this->responseView('EWRporta_ViewPublic_Modules', 'EWRporta_Modules', $viewParams);
	}

	public function actionModules()
	{
		if (!$this->perms['admin']) { return $this->responseNoPermission(); }

		if ($this->_request->isPost())
		{
			$modules = $this->_input->filterSingle('modules', XenForo_Input::ARRAY_SIMPLE);
			$this->getModelFromCache('EWRporta_Model_Modules')->updateModules($modules);

			return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, XenForo_Link::buildPublicLink('portal/modules'));
		}

		$modules = $this->getModelFromCache('EWRporta_Model_Modules')->getModules(false);
		$blocks = array('top' => array(), 'bottom' => array(), 'left' => array(), 'center' => array(), 'right' => array(), 'disabled' => array());

		foreach ($modules AS $module)
		{
			switch ($module['module_position'])
			{
				case "top":			$blocks['top'][] = $module;			break;
				case "bottom":		$blocks['bottom'][] = $module;		break;
				case "left":		$blocks['left'][] = $module;		break;
				case "center":		$blocks['center'][] = $module;		break;
				case "right":		$blocks['right'][] = $module;		break;
				case "disabled":	$blocks['disabled'][] = $module;	break;
			}
		}

		$viewParams = array(
			'adminModules' => true,
			'blocks' => $blocks,
		);

		return $this->responseView('EWRporta_ViewPublic_Modules', 'EWRporta_Modules', $viewParams);
	}

	public function actionEdit()
	{
		if (!$this->perms['admin']) { return $this->responseNoPermission(); }

		$modName = $this->_input->filterSingle('module_name', XenForo_Input::STRING);

		if (!$module = $this->getModelFromCache('EWRporta_Model_Modules')->getModuleByName($modName))
		{
			return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, XenForo_Link::buildPublicLink('portal/modules'));
		}

		if ($this->_request->isPost())
		{
			$input = $this->_input->filter(array(
				'module_name' => XenForo_Input::STRING,
				'module_cache' => XenForo_Input::STRING,
				'module_show' => XenForo_Input::ARRAY_SIMPLE,
				'module_hide' => XenForo_Input::ARRAY_SIMPLE,
				'module_locked' => XenForo_Input::UINT,
				'settings' => XenForo_Input::ARRAY_SIMPLE,
			));

			$this->getModelFromCache('EWRporta_Model_Settings')->updateSettings($input);
			return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, XenForo_Link::buildPublicLink('portal/modules'));
		}

		$viewParams = array(
			'module' => $module,
			'showGroups' => $this->getModelFromCache('XenForo_Model_UserGroup')->getUserGroupOptions($module['module_show']),
			'hideGroups' => $this->getModelFromCache('XenForo_Model_UserGroup')->getUserGroupOptions($module['module_hide']),
			'settings' => $this->getModelFromCache('EWRporta_Model_Settings')->getSettingsByModule($module['module_name']),
		);

		return $this->responseView('EWRporta_ViewPublic_Edit', 'EWRporta_Edit', $viewParams);
	}

	public function actionImport()
	{
		if (!$this->perms['admin']) { return $this->responseNoPermission(); }

		$fileTransfer = new Zend_File_Transfer_Adapter_Http();

		if ($fileTransfer->isUploaded('upload_file'))
		{
			$fileInfo = $fileTransfer->getFileInfo('upload_file');
			$fileName = $fileInfo['upload_file']['tmp_name'];

			$this->getModelFromCache('EWRporta_Model_Modules')->importModule($fileName);
		}

		return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, XenForo_Link::buildPublicLink('portal/modules'));
	}

	public function actionExport()
	{
		if (!$this->perms['admin']) { return $this->responseNoPermission(); }

		$modName = $this->_input->filterSingle('module_name', XenForo_Input::STRING);

		if (!$module = $this->getModelFromCache('EWRporta_Model_Modules')->getModuleByName($modName))
		{
			return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, XenForo_Link::buildPublicLink('portal/modules'));
		}

		$this->_routeMatch->setResponseType('xml');

		$viewParams = array(
			'module' => $module,
			'xml' => $this->getModelFromCache('EWRporta_Model_Modules')->exportModule($module),
		);

		return $this->responseView('EWRporta_ViewPublic_Export', '', $viewParams);
	}

	public function actionDelete()
	{
		if (!$this->perms['admin']) { return $this->responseNoPermission(); }

		$modName = $this->_input->filterSingle('module_name', XenForo_Input::STRING);

		if ($module = $this->getModelFromCache('EWRporta_Model_Modules')->getModuleByName($modName))
		{
			$this->getModelFromCache('EWRporta_Model_Modules')->deleteModule($module);
		}

		return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, XenForo_Link::buildPublicLink('portal/modules'));
	}

	public function actionEmpty()
	{
		if (!$this->perms['admin']) { return $this->responseNoPermission(); }

		$modName = $this->_input->filterSingle('module_name', XenForo_Input::STRING);

		if ($module = $this->getModelFromCache('EWRporta_Model_Modules')->getModuleByName($modName))
		{
			$this->getModelFromCache('EWRporta_Model_Cache')->emptyModuleCache($module);
		}

		return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, XenForo_Link::buildPublicLink('portal/modules'));
	}

	public static function getSessionActivityDetailsForList(array $activities)
	{
        $output = array();

        foreach ($activities as $key => $activity)
		{
			$output[$key] = array(
				new XenForo_Phrase('viewing_portal'),
				new XenForo_Phrase('index'),
				XenForo_Link::buildPublicLink('portal'),
				false
			);
        }

        return $output;
	}

	public function _preDispatch($action)
	{
		parent::_preDispatch($action);

		$this->perms = $this->getModelFromCache('EWRporta_Model_Perms')->getPermissions();
	}
}